#!/bin/sh

PATH=/bin:/usr/bin:/sbin:/usr/sbin export PATH

# rsync-wrapper shell script.  Copyright 2002-2011, Mike Bombich
# This script is executed when the root user from a remote machine
# successfully authenticates with a public key.  The privileges
# of that user on this server are limited to the functionality of this script.
# This wrapper will verify that the client is sending an rsync command.
# If it is, then the original, unaltered command is run, if not, 
# an error is returned.

log="/Library/Logs/CCC.log"
require_codesign=FALSE
read_only=FALSE

if [ "${SSH_ORIGINAL_COMMAND:=UNSET}" == "UNSET" ]; then
        echo "root login is not permitted to this machine via public key authentication." | tee -a $log
        exit 127
fi

declare -a command
command=($SSH_ORIGINAL_COMMAND)

# Is this an rsync request?
echo "${command[*]}" | /usr/bin/grep -e "^/private/var/root/rsync" >> /dev/null
rsyncRequest=$?

# Is this an scp request?
echo "${command[*]}" | /usr/bin/grep -e "^scp -t " | /usr/bin/grep -e " /private/var/root/rsync" >> /dev/null
scpRequest=$?

CAFFEINATE=""
if [ -x /usr/bin/caffeinate ]; then
	CAFFEINATE=/usr/bin/caffeinate
fi


# Make sure the original command is rsync
if [ "$rsyncRequest" == "0" ]; then
	if [ "$require_codesign" == "TRUE" ]; then
		/usr/bin/codesign -v -R='certificate root = H"2796bae63f1801e277261ba0d77770028f20eee4" or certificate root = H"611E5B662C593A08FF58D14AE22452D198DF6C60" and certificate leaf[subject.O] = "Bombich Software"* and identifier "rsync"' /private/var/root/rsync
		if [ ! $? = 0 ]; then
			exit 13
		fi
	fi

	# Ensure that --server is on the command line, to enforce running
	# rsync in server mode. If required, verify that --sender is specified

	server=false
	sender=false
	for arg in "${command[@]}"; do
		if [ "$arg" == "--sender" ]; then
			sender=true
		fi
		if [ "$arg" == "--server" ]; then
			server=true
		fi
	done
	
	if [ "$read_only" == "TRUE" -a "$sender" == "false" ]; then
		echo "This server requires read-only requests" | tee -a $log
		exit 125
	fi

	# If the command is an rsync server, execute the original command
	if [ "$server" == "true" ]; then
		$CAFFEINATE $SSH_ORIGINAL_COMMAND
	else
		echo "This does not appear to be a valid rsync request" | tee -a $log
		exit 125
	fi

elif [ "$scpRequest" == "0" ]; then
	now=`date '+%m/%d %H:%M:%S'`
	printf "$now\tRemoving older rsync binaries\n" >> $log
	/usr/bin/find /private/var/root -name "rsync.*" -mtime +3d -exec rm '{}' \;
	$SSH_ORIGINAL_COMMAND  

elif [ "${command[0]}" == "enableOwnership" ]; then
	now=`date '+%m/%d %H:%M:%S'`
	tgt=`echo "$SSH_ORIGINAL_COMMAND" | cut -c 17-`
	printf "$now\tEnabling ownership on $tgt\n" >> $log
	os=`/usr/sbin/sysctl -n kern.osrelease | awk -F. '{print $1}'`
	# Leopard is "9". Snow Leopard added the enableOwnership verb to Disk Utility
	# vsdbutil can only accept a mountpoint. If the user specified a subfolder, the task fails
	if [ $os -gt 9 ]; then     
		/usr/sbin/diskutil enableOwnership "$tgt" | tee -a $log
	else
		/usr/sbin/vsdbutil -a "$tgt"
	fi
	exit 0

elif [ "${command[0]}" == "update_dyld_shared_cache" ]; then
	tgt=`echo "$SSH_ORIGINAL_COMMAND" | cut -c 26-`
	os=`/usr/sbin/sysctl -n kern.osrelease | awk -F. '{print $1}'`
	# Tiger is "8"
	if [ -f "$tgt/System/Library/CoreServices/SystemVersion.plist" -a $os -gt 8 -a -x "$tgt"/usr/bin/update_dyld_shared_cache ]; then
		now=`date '+%m/%d %H:%M:%S'`
		printf "$now\tUpdating the Mac OS X \"Dynamic Linker Shared Cache\" on \"$tgt\"\n" >> $log
		/bin/rm -rf "$tgt"/System/Library/Caches/com.apple.kext.caches/Startup
		$CAFFEINATE "$tgt"/usr/bin/update_dyld_shared_cache -root "$tgt" >> $log 2>> $log &
	fi
	exit 0

else
	echo "Command rejected by rsync_wrapper: `date`: ${command[@]}" | tee -a $log
	echo "That command is not allowed with the root account via public key authentication."
	exit 125
fi
